% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/units.R
\name{simplifyUnit}
\alias{simplifyUnit}
\title{Simplify units by removing repeated units from the numerator and denominator}
\usage{
simplifyUnit(numerator = "", denominator = "")
}
\arguments{
\item{numerator}{The numerator of the units (or the whole unit specification)}

\item{denominator}{The denominator of the units (or NULL if \code{numerator}
is the whole unit specification)}
}
\value{
The units specified with units that are in both the numerator and
  denominator cancelled.
}
\description{
Simplify units by removing repeated units from the numerator and denominator
}
\details{
\code{NA} or \code{""} for \code{numerator} and \code{denominator}
  are considered unitless.
}
\examples{
simplifyUnit("kg", "kg/mL")
# units that don't match exactly are not cancelled
simplifyUnit("kg", "g/mL")
}
\seealso{
Other Unit conversion: 
\code{\link{modelUnitConversion}()}
}
\concept{Unit conversion}
