% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_degradation.R
\name{plot_degradation}
\alias{plot_degradation}
\title{Save multipanel plots with reference and test sounds}
\usage{
plot_degradation(
  X,
  nrow = 4,
  env.smooth = getOption("env.smooth", 200),
  hop.size = getOption("hop.size", 11.6),
  wl = getOption("wl", NULL),
  ovlp = getOption("ovlp", 70),
  path = getOption("sound.files.path", "."),
  dest.path = getOption("dest.path", "."),
  cores = getOption("mc.cores", 1),
  pb = getOption("pb", TRUE),
  collevels = seq(-120, 0, 5),
  palette = viridis::viridis,
  flim = c("-1", "+1"),
  envelope = TRUE,
  spectrum = TRUE,
  heights = c(4, 1),
  widths = c(5, 1),
  margins = c(2, 1),
  row.height = 2,
  col.width = 2,
  cols = viridis::mako(4, alpha = 0.3),
  res = 120,
  ...
)
}
\arguments{
\item{X}{The output of \code{\link{set_reference_sounds}} which is an object of class 'data.frame', 'selection_table' or 'extended_selection_table' (the last 2 classes are created by the function \code{\link[warbleR]{selection_table}} from the warbleR package) with the reference to the test sounds . Must contain the following columns: 1) "sound.files": name of the .wav files, 2) "selec": unique selection identifier (within a sound file), 3) "start": start time and 4) "end": end time of selections, 5) "bottom.freq": low frequency for bandpass, 6) "top.freq": high frequency for bandpass, 7) "sound.id": ID of sounds used to identify counterparts across distances and 8) "reference": identity of sounds to be used as reference for each test sound (row). See \code{\link{set_reference_sounds}} for more details on the structure of 'X'.}

\item{nrow}{Numeric vector of length 1 with the number of rows per image file. Default is 4. This would be dynamically adjusted if more rows than needed are set.}

\item{env.smooth}{Numeric vector of length 1 determining the length of the sliding window (in amplitude samples) used for a sum smooth for amplitude envelope and power spectrum calculations (used internally by \code{\link[seewave]{env}}). Default is 200.}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 11.6 ms, which is equivalent to 512 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied.}

\item{wl}{a vector with a single even integer number specifying the window length of the spectrogram, default is \code{NULL}. If supplied, 'hop.size' is ignored. Odd integers will be rounded up to the nearest even number.}

\item{ovlp}{Numeric vector of length 1 specifying the percentage of overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Only used when plotting. Default is 70. Applied to both spectra and spectrograms on image files.}

\item{path}{Character string containing the directory path where the sound files are found. Only needed when 'X' is not an extended selection table. If not supplied the current working directory is used.}

\item{dest.path}{Character string containing the directory path where the image files will be saved. If not supplied the current working directory will be used instead.}

\item{cores}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.}

\item{collevels}{Numeric vector indicating a set of levels which are used to partition the amplitude range of the spectrogram (in dB) as in \code{\link[seewave]{spectro}}. Default is \code{seq(-120, 0, 5)}.}

\item{palette}{A color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}}. Default is \code{\link[viridis]{viridis}}.}

\item{flim}{A numeric vector of length 2 indicating the highest and lowest frequency limits (kHz) of the spectrogram, as in \code{\link[seewave]{spectro}}. Default is \code{NULL}. Alternatively, a character vector similar to \code{c("-1", "1")} in which the first number is the value to be added to the minimum bottom frequency in 'X' and the second the value to be added to the maximum top frequency in 'X'. This is computed independently for each sound id so the frequency limit better fits the frequency range of the annotated signals. This is useful when test sounds show marked differences in their frequency ranges.}

\item{envelope}{Logical to control if envelopes are plotted. Default is \code{TRUE}.}

\item{spectrum}{Logical to control if power spectra are plotted. Default is \code{TRUE}.}

\item{heights}{Numeric vector of length 2 to control the relative heights of spectrogram (first number) and amplitude envelope (second number) when \code{envelope = TRUE}. Default is c(4, 1).}

\item{widths}{Numeric vector of length 2 to control the relative widths of spectrogram (first number) and power spectrum (second number) when \code{spectrum = TRUE}. Default is c(5, 1).}

\item{margins}{Numeric vector of length 2 to control the relative time of the test sound (first number) and adjacent margins (i.e. adjacent background noise, second number) to be included in the spectrogram \code{spectrum = TRUE}. Default is c(2, 1) which means that each margin next to the sound is half the duration of the sound. Note that all spectrograms will have the same time length so margins will be calculated to ensure all spectrograms match the duration of the spectrogram in the longest sound. As such, this argument controls the margin on the longest sound.}

\item{row.height}{Numeric vector of length 1 controlling the height (in inches) of sound panels in the output image file. Default is 2.}

\item{col.width}{Numeric vector of length 1 controlling the width (in inches) of sound panels in the output image file. Default is 2.}

\item{cols}{Character vector of length 4 containing the colors to be used for the background of column and row title panels (element 1), the color of amplitude envelopes (element 2), the color of power spectra (element 3), and the background color of envelopes and spectra (element 4).}

\item{res}{Numeric argument of length 1. Controls image resolution. Default is 120 (faster) although 300 - 400 is recommended for publication/presentation quality.}

\item{...}{Additional arguments to be passed to the internal spectrogram
creating function for customizing graphical output. The function is a modified
version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
One ore more image files with a multipanel figure of spectrograms of test sound by distance, sound id and transect. It also returns the file path of the images invisibly.
}
\description{
\code{plot_degradation} creates multipanel plots (as image files) with reference and test sounds by distance and transect.
}
\details{
The function aims to simplify the visual inspection of sound degradation by producing multipanel figures (saved in 'dest.path') containing visualizations of each test sound and its reference. Sounds are sorted by distance (columns) and transect (if more than 1). Visualizations include spectrograms, amplitude envelopes and power spectra (the last 2 are optional). Each row includes all the copies of a sound id for a given transect (the row label includes the sound id in the first line and transect in the second line), also including its reference if it comes from another transect. Ambient noise annotations (sound.id 'ambient') are excluded. Amplitude envelopes and power spectra are computed using the functions  \code{\link[warbleR]{envelope}} (warbleR package) and \code{\link[seewave]{spec}} (seewave package) respectively. This two visualizations show the power distribution in time and frequency between the minimum and maximum power values for each sound. Therefore scales are not necessarily comparable across panels.
}
\examples{
\donttest{
  # load example data
  data("test_sounds_est")

  # order so spectrograms from same sound id as close in the graph
  test_sounds_est <- test_sounds_est[order(test_sounds_est$sound.id), ]

  # set directory to save image files
  options(dest.path = tempdir())

  # method 1
  Y <- set_reference_sounds(X = test_sounds_est)

  # plot degradation spectrograms
  plot_degradation(
    X = Y, nrow = 3, ovlp = 95
  )

  # using other color palettes
  plot_degradation(
    X = Y, nrow = 3, ovlp = 95,
    cols = viridis::magma(4, alpha = 0.3),
    palette = viridis::magma
  )

  # missing some data, 2 rows
  plot_degradation(
    X = Y[-3, ], nrow = 2, ovlp = 95,
    cols = viridis::mako(4, alpha = 0.4), palette = viridis::mako, wl = 200
  )

  # changing marging and high overlap
  plot_degradation(X = Y, margins = c(5, 1), nrow = 6, ovlp = 95)

  # more rows than needed (will adjust it automatically)
  plot_degradation(X = Y, nrow = 10, ovlp = 90)
}

}
\references{
{
Araya-Salas M., E. Grabarczyk, M. Quiroz-Oliva, A. Garcia-Rodriguez, A. Rico-Guevara. (2023), baRulho: an R package to quantify degradation in animal acoustic signals .bioRxiv 2023.11.22.568305.
}
}
\seealso{
\code{\link{blur_ratio}}, \code{\link{plot_aligned_sounds}}, \code{\link{plot_degradation}}

Other quantify degradation: 
\code{\link{blur_ratio}()},
\code{\link{detection_distance}()},
\code{\link{envelope_correlation}()},
\code{\link{plot_blur_ratio}()},
\code{\link{set_reference_sounds}()},
\code{\link{signal_to_noise_ratio}()},
\code{\link{spcc}()},
\code{\link{spectrum_blur_ratio}()},
\code{\link{spectrum_correlation}()},
\code{\link{tail_to_signal_ratio}()}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{quantify degradation}
