% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noise_profile.R
\name{noise_profile}
\alias{noise_profile}
\title{Measure full spectrum sound noise profiles}
\usage{
noise_profile(X = NULL, files = NULL, mar = NULL, 
noise.ref = "adjacent", parallel = 1, pb = TRUE, path = NULL,
bp = NULL, hop.size = 1, wl = NULL, PSD = FALSE, norm = TRUE, dB = "A", averaged = TRUE)
}
\arguments{
\item{X}{object of class 'extended_selection_table' created by the function \code{\link[warbleR]{selection_table}} from the warbleR package. Default is \code{NULL}.}

\item{files}{Character vector with names of wave files to be analyzed. Files must be found in 'path' supplied (or in the working directory if 'path' is not supplied). Default is \code{NULL}.}

\item{mar}{numeric vector of length 1. Specifies the margins adjacent to
the start and end points of selection over which to measure ambient noise. Required if 'X' is supplied and ignored if not supplied. Default is \code{NULL}.}

\item{noise.ref}{Character vector of length 1 to determined which noise segment must be used for measuring ambient noise. Ignored if 'X' is not supplied. Two options are available: 
\itemize{
\item \code{adjacent}: measure ambient noise right before the signal (using argument 'mar' to define duration of ambient noise segments). 
\item \code{custom}: measure ambient noise segments referenced in the selection table (labeled as 'ambient' in the 'signal.type' column).
}}

\item{parallel}{Numeric vector of length 1. Controls whether parallel computing is applied by specifying the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}.}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used.}

\item{bp}{Numeric vector of length 2 giving the lower and upper limits of a frequency bandpass filter (in kHz). Default is \code{NULL}.}

\item{hop.size}{A numeric vector of length 1 specifying the time window duration (in ms). Default is 1 ms, which is equivalent to ~45 wl for a 44.1 kHz sampling rate. Ignored if 'wl' is supplied.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is NULL. Ignored if \code{bp = NULL}. If supplied, 'hop.size' is ignored. 
Note that lower values will increase time resolution, which is more important for amplitude ratio calculations.}

\item{PSD}{Logical to control whether the Probability Mass Function (the probability distribution of frequencies). See \code{\link[seewave]{meanspec}}. Default is \code{FALSE}.}

\item{norm}{Logical to control whether amplitude values are normalized (divided by the maximum) so the highest value is 1. See \code{\link[seewave]{meanspec}}. Default is \code{TRUE}.}

\item{dB}{A character string of length 1 specifying the type dB to return: "max0" for a maximum dB value at 0, "A", "B", "C", "D", and "ITU" for common dB weights. See \code{\link[seewave]{meanspec}}. Default is \code{"A"}.}

\item{averaged}{Logical to control if frequency spectra are averaged within a sound file. Default is \code{TRUE}.}
}
\value{
A list containing the the frequency spectra for each sound file or wave object (if 'X' is supplied).
}
\description{
\code{noise_profile} Measure full spectrum sound pressure levels (i.e. noise profiles) in sound files or extended selection tables.
}
\details{
The function `noise_profile()` allows to estimate full spectrum sound pressure levels (i.e. noise profiles) of ambient noise. This can be done on extended selection tables (using the segments containing no signal) or over complete sound files in the working directory (or path supplied). The function uses \code{\link[seewave]{meanspec}} internally to calculate frequency spectra.
}
\examples{
{
# load example data
data("playback_est")

# custom noise reference
noise_profile(X = playback_est, mar = 0.01, pb = FALSE, noise.ref = "custom")

# remove noise selections
pe <- playback_est[playback_est$signal.type != "ambient", ]
 
 noise_profile(X = pe, mar = 0.01, pb = FALSE, noise.ref = "adjacent")
}

}
\references{
{
Araya-Salas, M. (2020). baRulho: baRulho: quantifying habitat-induced degradation of (animal) acoustic signals in R. R package version 1.0.2.

}
}
\seealso{
\code{\link{excess_attenuation}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
