% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subscriptions.R
\name{subscribe}
\alias{subscribe}
\alias{unsubscribe}
\title{Subscribe/Unsubscribe to a topic}
\usage{
subscribe(topic, endpoint, protocol, ...)

unsubscribe(subscription, ...)
}
\arguments{
\item{topic}{A character string containing an SNS Topic Amazon Resource Name (ARN).}

\item{endpoint}{A character string containing the endpoint to be subscribed (e.g., an email address).}

\item{protocol}{The allowed protocol types are: default, email, email-json, sqs, sms, http, https, and application.}

\item{...}{Additional arguments passed to \code{\link{snsHTTP}}.}

\item{subscription}{A character string containing an SNS Subscription Amazon Resource Name (ARN).}
}
\value{
If successful, a character string containing a subscription ARN. Otherwise, a data structure of class \dQuote{aws_error} containing any error message(s) from AWS and information about the request attempt.
}
\description{
Subscribes an endpoint to the specified SNS topic.
}
\details{
\code{subscribe} initiates a subscription of an endpoint to an SNS topic. For example, this is used to add an email address endpoint to a topic. Subscriptions need to be confirmed by the endpoint. For example, an SMS endpoint will require an SMS response to an subscription invitation message. Subscriptions can be removed using \code{\link{unsubscribe}} (or whatever method is described in the invitation message); thus subscriptions can be handled by both users and administrator (you).

\code{unsubscribe} unsubscribes an endpoint from an SNS topic.
}
\examples{
\dontrun{
  top <- create_topic("new_topic")
  # email subscription
  subscribe(top, "example@example.com", protocol = "email")

  # sms subscription
  subscribe(top, "555-123-4567", protocol = "sms")

  delete_topic(top)
}

}
\author{
Thomas J. Leeper
}
\references{
\href{http://docs.aws.amazon.com/sns/latest/api/API_Subscribe.html}{Subscribe}
\href{http://docs.aws.amazon.com/sns/latest/api/API_Unsubscribe.html}{Unsubscribe}
}
\seealso{
\code{\link{list_subscriptions}}
}

