% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_purchase_host_reservation}
\alias{ec2_purchase_host_reservation}
\title{Purchase Host Reservation}
\usage{
ec2_purchase_host_reservation(
  HostIdSet,
  OfferingId,
  ClientToken = NULL,
  CurrencyCode = NULL,
  LimitPrice = NULL,
  TagSpecification = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{HostIdSet}{List. The IDs of the Dedicated Hosts with which the reservation will be associated.}

\item{OfferingId}{String. The ID of the offering.}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{CurrencyCode}{String. The currency in which the \code{totalUpfrontPrice}, \code{LimitPrice}, and \code{totalHourlyPrice} amounts are specified....[optional]}

\item{LimitPrice}{String. The specified limit is checked against the total upfront cost of the reservation (calculated as the offering\'s upfront cost multiplied by the host count)....[optional]}

\item{TagSpecification}{List. The tags to apply to the Dedicated Host Reservation during purchase.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Purchase a reservation with configurations that
match those of your Dedicated Host. You must have active Dedicated Hosts
in your account before you purchase a reservation. This action results
in the specified reservation being purchased and charged to your
account.
}
\section{HostIdSet}{

The IDs of the Dedicated Hosts with
which the reservation will be associated.
}

\section{OfferingId}{

The ID of
the offering.
}

\section{ClientToken}{

Unique, case-sensitive identifier that
you provide to ensure the idempotency of the request. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

\section{CurrencyCode}{

The
currency in which the \code{totalUpfrontPrice}, \code{LimitPrice}, and
\code{totalHourlyPrice} amounts are specified. At this time, the only
supported currency is \code{USD}.
}

\section{LimitPrice}{

The specified limit is
checked against the total upfront cost of the reservation (calculated as
the offering\'s upfront cost multiplied by the host count). If the total
upfront cost is greater than the specified price limit, the request
fails. This is used to ensure that the purchase does not exceed the
expected upfront cost of the purchase. At this time, the only supported
currency is \code{USD}. For example, to indicate a limit price of USD 100,
specify 100.00.
}

\section{TagSpecification}{

The tags to apply to the Dedicated
Host Reservation during purchase.
}

