% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_hosts}
\alias{ec2_describe_hosts}
\title{Describe Hosts}
\usage{
ec2_describe_hosts(
  Filter = NULL,
  HostId = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{HostId}{List. The IDs of the Dedicated Hosts. The IDs are used for targeted instance launches.[optional]}

\item{MaxResults}{Integer.   The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Hosts
}
\section{Filter}{


The filters.
\itemize{
\item \code{auto-placement} - Whether auto-placement is enabled or disabled
(\code{on} \| \code{off}).
\item \code{availability-zone} - The Availability Zone of the host.
\item \code{client-token} - The idempotency token that you provided when you
allocated the host.
\item \code{host-reservation-id} - The ID of the reservation assigned to this
host.
\item \code{instance-type} - The instance type size that the Dedicated Host is
configured to support.
\item \code{state} - The allocation state of the Dedicated Host (\code{available} \|
\code{under-assessment} \| \code{permanent-failure} \| \code{released} \|
\code{released-permanent-failure}).
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
}
}

\section{HostId}{

The IDs of the Dedicated Hosts. The IDs are used
for targeted instance launches.
}

\section{MaxResults}{


The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned \code{nextToken} value. This value can be between 5 and 500. If
\code{maxResults} is given a larger value than 500, you receive an error.

You cannot specify this parameter and the host IDs parameter in the same
request.
}

