% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_create_traffic_mirror_target}
\alias{ec2_create_traffic_mirror_target}
\title{Create Traffic Mirror Target}
\usage{
ec2_create_traffic_mirror_target(
  NetworkInterfaceId = NULL,
  NetworkLoadBalancerArn = NULL,
  Description = NULL,
  TagSpecification = NULL,
  DryRun = NULL,
  ClientToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{NetworkInterfaceId}{String. The network interface ID that is associated with the target.[optional]}

\item{NetworkLoadBalancerArn}{String. The Amazon Resource Name (ARN) of the Network Load Balancer that is associated with the target.[optional]}

\item{Description}{String. The description of the Traffic Mirror target.[optional]}

\item{TagSpecification}{List. The tags to assign to the Traffic Mirror target.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Create Traffic Mirror Target
}
\section{NetworkInterfaceId}{

The
network interface ID that is associated with the
target.
}

\section{NetworkLoadBalancerArn}{

The Amazon Resource Name (ARN) of the
Network Load Balancer that is associated with the
target.
}

\section{Description}{

The description of the Traffic Mirror
target.
}

\section{TagSpecification}{

The tags to assign to the Traffic Mirror
target.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{ClientToken}{

Unique, case-sensitive
identifier that you provide to ensure the idempotency of the request.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.
}

