% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_aweek.R
\name{get_aweek}
\alias{get_aweek}
\alias{get_date}
\title{Convert week numbers to dates or aweek objects}
\usage{
get_aweek(week = 1L, year = format(Sys.Date(), "\%Y"), day = 1L,
  start = week_start, week_start = get_week_start(), ...)

get_date(week = 1L, year = format(Sys.Date(), "\%Y"), day = 1L,
  start = get_week_start())
}
\arguments{
\item{week}{an integer vector, defaults to 1, representing the first week of the year.}

\item{year}{an integer vector, defaults to the current year}

\item{day}{an integer vector, defaults to 1, representing the first day of
the first week of the year.}

\item{start}{an integer (or character) vector of days that the weeks
start on for each corresponding week. Defaults to the value of
\code{\link[=get_week_start]{get_week_start()}}. Note that these will not determine the final week.}

\item{week_start}{a number indicating the start of the week based on the ISO
8601 standard from 1 to 7 where 1 = Monday OR an abbreviation of the
weekdate in an English or current locale. \emph{Note: using a non-English locale
may render your code non-portable.} Defaults to the value of
\code{\link[=get_week_start]{get_week_start()}}}

\item{...}{parameters passed on to \code{\link[=date2week]{date2week()}}}
}
\value{
\itemize{
\item get_aweek(): an aweek object
\item get_date(): a Date object
}
}
\description{
These are vectorized functions that take integer vectors and return Date or
an aweek objects, making it easier to convert bare weeks to dates.
}
\note{
Any missing weeks, years, or start elements will result in a
missing element in the resulting vector. Any missing days will
revert to the first day of the week.
}
\examples{

# The default results in the first week of the year using the default
# default week_start (from get_week_start())

get_aweek()
get_date() # this is equivalent to as.Date(get_week()), but faster 

# Some years, like 2015, have 53 weeks

get_aweek(53, 2015)

# If you specify 53 weeks for a year that doesn't have 53 weeks, aweek will
# happily correct it for you

get_aweek(53, 2014) # this will be 2015-W01-1

# you can use this to quickly make a week without worrying about formatting
# here, you can define an observation interval of 20 weeks

obs_start <- get_date(week = 10, year = 2018)
obs_end   <- get_date(week = 29, year = 2018, day = 7)
c(obs_start, obs_end)

# If you have a data frame of weeks, you can use it to convert easily

mat <- matrix(c(
  2019, 11, 1, 7, # 2019-03-10
  2019, 11, 2, 7,
  2019, 11, 3, 7,
  2019, 11, 4, 7,
  2019, 11, 5, 7,
  2019, 11, 6, 7,
  2019, 11, 7, 7
), ncol = 4, byrow = TRUE)

colnames(mat) <- c("year", "week", "day", "start")
m <- as.data.frame(mat)
m
sun <- with(m, get_date(week, year, day, start))
sun
as.aweek(sun) # convert to aweek starting on the global week_start 
as.aweek(sun, week_start = "Sunday") # convert to aweek starting on Sunday

# You can also change starts
mon <- with(m, get_aweek(week, year, day, "Monday", week_start = "Monday"))
mon
as.Date(mon)

# If you use multiple week starts, it will convert to date and then to
# the correct week, so it won't appear to match up with the original
# data frame.

sft <- with(m, get_aweek(week, year, day, 7:1, week_start = "Sunday"))
sft
as.Date(sft)
}
\seealso{
\code{\link[=as.aweek]{as.aweek()}} \code{\link[=date2week]{date2week()}} \code{\link[=week2date]{week2date()}}
}
