#' @title Allan variance of IMU Data from a navchip sensor
#' @description This data set contains Allan variance of gyroscope and accelerometer data from a navchip sensor.
#' @format A list of the following elements:
#' \itemize{
#'  \item "sensor": Name of the sensor.
#'  \item "freq": The frequency at which the error signal is measured.
#'  \item "n": Sample size of the data.
#'  \item "type": The types of sensors considered in the data.
#'  \item "axis": The axes of sensors considered in the data.
#'  \item "avar": A list containing the computed Allan variance based on the data.
#' }
#' @source The IMU data of the navchip sensor comes from Geodetic Engineering Laboratory (TOPO) and Swiss Federal Institute of Technology Lausanne (EPFL).
"navchip_av"

#' @title Allan variance of IMU Data from an ADIS 16405 sensor
#' @description This data set contains Allan variance of gyroscope and accelerometer data from an ADIS 16405 sensor.
#' @format A list of the following elements:
#' \itemize{
#'  \item "sensor": Name of the sensor.
#'  \item "freq": The frequency at which the error signal is measured.
#'  \item "n": Sample size of the data.
#'  \item "type": The types of sensors considered in the data.
#'  \item "axis": The axes of sensors considered in the data.
#'  \item "avar": A list containing the computed Allan variance based on the data.
#' }
#' @source The IMU data comes from Department of Geomatics Engineering, University of Calgary.
"adis_av"

#' @title Allan variance of IMU Data from a KVH1750 IMU  sensor
#' @description This data set contains Allan variance of gyroscope and accelerometer data from an KVH1750 sensor.
#' @format A list of the following elements:
#' \itemize{
#'  \item "sensor": Name of the sensor.
#'  \item "freq": The frequency at which the error signal is measured.
#'  \item "n": Sample size of the data.
#'  \item "type": The types of sensors considered in the data.
#'  \item "axis": The axes of sensors considered in the data.
#'  \item "avar": A list containing the computed Allan variance based on the data.
#' }
#' @source The IMU data comes from Department of Geomatics Engineering, University of Calgary.
"kvh1750_av"

#' @title Allan variance of IMU Data from IMAR Gyroscopes
#' @description This data set contains Allan variance of IMAR gyroscopes data.
#' @format A list of the following elements:
#' \itemize{
#'  \item "sensor": Name of the sensor.
#'  \item "freq": The frequency at which the error signal is measured.
#'  \item "n": Sample size of the data.
#'  \item "type": The types of sensors considered in the data.
#'  \item "axis": The axes of sensors considered in the data.
#'  \item "avar": A list containing the computed Allan variance based on the data.
#' }
#' @source The IMU data comes from Geodetic Engineering Laboratory (TOPO) and Swiss Federal Institute of Technology Lausanne (EPFL).
"imar_av"

#' #' @title Allan variance of IMU Data from a LN200 sensor
#' #' @description This data set contains Allan variance of LN200 gyroscope and accelerometer data.
#' #' @format A list of the following elements:
#' #' \itemize{
#' #'  \item "sensor": Name of the sensor.
#' #'  \item "freq": The frequency at which the error signal is measured.
#' #'  \item "n": Sample size of the data.
#' #'  \item "type": The types of sensors considered in the data.
#' #'  \item "axis": The axes of sensors considered in the data.
#' #'  \item "avar": A list containing the computed Allan variance based on the data.
#' #' }
#' #' @source The IMU data comes from Geodetic Engineering Laboratory (TOPO) and Swiss Federal Institute of Technology Lausanne (EPFL).
#' "ln200_av"
