# autohrf

An R Package for Generating Data-Informed GLM Models in Task-Based fMRI Data Analysis

## Description

Analysis of task-related fMRI activity at the level of individual participants is commonly based on general linear modelling (GLM) that allows us to estimate to what extent the BOLD signal can be explained by task response predictors specified in the GLM model. The predictors are constructed by convolving the hypothesised timecourse of neural activity with an assumed hemodynamic response function (HRF). To get valid and precise estimates of task response, it is important to construct a model of neural activity that best matches actual neuronal activity. The construction of models is most often driven by predefined assumptions on the components of brain activity and their duration based on the task design and specific aims of the study. However, our assumptions about the onset and duration of component processes might be wrong and can also differ across brain regions. This can result in inappropriate or suboptimal models, bad fitting of the model to the actual data and invalid estimations of brain activity. Here we present an approach in which theoretically driven models of task response are used to define constraints based on which the final model is derived computationally using the actual data. Specifically, we developed autohrf — a package for the R programming language that allows for data-driven estimation of HRF models. The package uses genetic algorithms to efficiently search for models that fit the underlying data well. The package uses automated parameter search to find the onset and duration of task predictors which result in the highest fitness of the resulting GLM based on the fMRI signal under predefined restrictions. We evaluate the usefulness of the autohrf package on publicly available datasets of task-related fMRI activity. Our results suggest that by using autohrf users can find better task related brain activity models in a quick and efficient manner.

## Funding

This work was supported by the Slovenian Research Agency (Young Researcher program and the research grants J3-9264, P3-0338, P5-0110).
