% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noauto_scorecard2.R
\name{noauto_scorecard2}
\alias{noauto_scorecard2}
\title{Manually Input Parameters to Generate Scorecards
The basic score is dispersed into each feature score}
\usage{
noauto_scorecard2(
  bins_card,
  fit,
  bins_woe,
  points0 = 600,
  odds0 = 1/19,
  pdo = 50,
  k = 3
)
}
\arguments{
\item{bins_card}{Binning template.}

\item{fit}{See glm {stats}.}

\item{bins_woe}{Base point.}

\item{points0}{odds.}

\item{odds0}{Point-to Double Odds.}

\item{pdo}{A data frame of woe with independent variables and target variable.}

\item{k}{Each scale doubles the probability of default several times.}
}
\value{
A data frame with score ratings.
}
\description{
Manually Input Parameters to Generate Scorecards
The basic score is dispersed into each feature score
}
\examples{
accepts <- read.csv( system.file( "extdata", "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
d = sort( sample( nrow( feature ), nrow( feature )*0.7))
train <- feature[d,]
test <- feature[-d,]
treebins_train <- bins_tree( df = train, key_var = "application_id", y_var="bad_ind",
max_depth=3, p=0.1)
woe_train <- rep_woe( df= train , key_var = "application_id", y_var = "bad_ind" ,
tool = treebins_train ,var_label = "variable",col_woe = 'woe', lower = 'lower' , upper = 'upper')
woe_test <- rep_woe(  df = test , key_var ="application_id", y_var= "bad_ind",
tool = treebins_train ,var_label= "variable",
    col_woe = 'woe', lower = 'lower' ,upper = 'upper'  )
lg <- stats::glm( bad_ind~. , family = stats::binomial( link = 'logit' ) , data = woe_train )
lg_both <- stats::step( lg , direction = "both")
Score2 <- noauto_scorecard2( bins_card= woe_test , fit =lg_both , bins_woe = treebins_train ,
points0 = 600 , odds0 = 1/20 , pdo = 50 )
}
