% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectedPlot.R
\name{expectedPlot}
\alias{expectedPlot}
\title{Draw an adjusted Plot for a numeric predictor}
\usage{
expectedPlot(
  fit,
  xname = NULL,
  no = 2,
  maxy.lev = 5,
  median = TRUE,
  mark.time = FALSE,
  se = FALSE,
  type = "ggplot",
  ...
)
}
\arguments{
\item{fit}{An object of class "coxph"}

\item{xname}{Character Name of explanatory variable to plot}

\item{no}{integer Number of groups to be made}

\item{maxy.lev}{Integer Maximum unique length of a numeric variable to be treated as categorical variables}

\item{median}{Logical}

\item{mark.time}{logical Whether or not mark time}

\item{se}{logical Whether or not show se}

\item{type}{Character "plot" or "ggplot"}

\item{...}{further arguments to be passed to plot.survfit}
}
\value{
No return value, called for side effects
}
\description{
Select cutpoint for a numeric predictor with maxstat.test() and draw survival plot with this cutpoint
}
\examples{
library(survival)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~age+sex,data =colon)
expectedPlot(fit,xname="age")
fit=coxph(Surv(time,status)~rx+logWBC,data=anderson)
expectedPlot(fit,xname="logWBC",no=3)
}
