% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_subset_classifier.R
\name{best_subset_classifier}
\alias{best_subset_classifier}
\title{Best subset classifier}
\usage{
best_subset_classifier(
  model,
  data.train,
  model.family,
  model.optimizer,
  n.iter,
  verbose = c(TRUE, FALSE)
)
}
\arguments{
\item{model}{Multilevel model. A model formula describing the multilevel
model to be estimated on the basis of the provided training data.}

\item{data.train}{Training data. A data.frame containing the training data
used to train the model.}

\item{model.family}{Model family. A variable indicating the model family
to be used by glmer. Defaults to binomial(link = "probit").}

\item{model.optimizer}{Optimization method. A character-valued scalar
describing the optimization method to be used by glmer. Defaults to
"bobyqa".}

\item{n.iter}{Iterations. A integer-valued scalar specifying the maximum
number of function evaluations tried by the optimization method.}

\item{verbose}{Verbose output. A logical vector indicating whether or not
verbose output should be printed.}
}
\value{
The multilevel model. An \code{\link[lme4]{glmer}} object.
}
\description{
\code{best_subset_classifier} applies best subset classification to a data
set.
}
