% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnet.R
\name{pfa.glmnet}
\alias{pfa.glmnet}
\title{PFA Formatting of Fitted glmnet objects}
\source{
pfa_config.R avro_typemap.R avro.R pfa_cellpool.R pfa_expr.R pfa_utils.R
}
\usage{
\method{pfa}{glmnet}(object, name = NULL, version = NULL, doc = NULL,
  metadata = NULL, randseed = NULL, options = NULL, lambda = NULL,
  pred_type = c("response", "prob"), cutoffs = NULL, ...)
}
\arguments{
\item{object}{an object of class "glmnet"}

\item{name}{a character which is an optional name for the scoring engine}

\item{version}{an integer which is sequential version number for the model}

\item{doc}{a character which is documentation string for archival purposes}

\item{metadata}{a \code{list} of strings that is computer-readable documentation for 
archival purposes}

\item{randseed}{a integer which is a global seed used to generate all random 
numbers. Multiple scoring engines derived from the same PFA file have 
different seeds generated from the global one}

\item{options}{a \code{list} with value types depending on option name 
Initialization or runtime options to customize implementation 
(e.g. optimization switches). May be overridden or ignored by PFA consumer}

\item{lambda}{a numeric value of the penalty parameter lambda at which 
coefficients are required}

\item{pred_type}{a string with value "response" for returning a prediction on the 
same scale as what was provided during modeling, or value "prob", which for classification 
problems returns the probability of each class.}

\item{cutoffs}{(Classification only) A named numeric vector of length equal to 
number of classes. The "winning" class for an observation is the one with the 
maximum ratio of predicted probability to its cutoff. The default cutoffs assume the 
same cutoff for each class that is 1/k where k is the number of classes}

\item{...}{additional arguments affecting the PFA produced}
}
\value{
a \code{list} of lists that compose valid PFA document
}
\description{
This function takes a generalized linear model fit using glmnet  
and returns a list-of-lists representing a valid PFA document 
that could be used for scoring
}
\examples{
X <- matrix(c(rnorm(100), runif(100)), nrow=100, ncol=2)
Y <- factor(3 - 5 * X[,1] + 3 * X[,2] + rnorm(100, 0, 3) > 0)

model <- glmnet::glmnet(X, Y, family = 'binomial')
model_as_pfa <- pfa(model)
}
\seealso{
\code{\link[glmnet]{glmnet}} \code{\link{extract_params.glmnet}}
}
