% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-set-awk-path.r
\name{auk_set_awk_path}
\alias{auk_set_awk_path}
\title{Set a custom path to AWK executable}
\usage{
auk_set_awk_path(path, overwrite = FALSE)
}
\arguments{
\item{path}{character; path to the AWK executable on your system, e.g.
\code{"C:/cygwin64/bin/gawk.exe"} or \code{"/usr/bin/awk"}.}

\item{overwrite}{logical; should the existing \code{AWK_PATH} be overwritten if it
has already been set in .Renviron.}
}
\value{
Edits .Renviron, then returns the AWK path invisibly.
}
\description{
If AWK has been installed in a non-standard location, the environment
variable \code{AWK_PATH} must be set to specify the location of the executable.
Use this function to set \code{AWK_PATH} in your .Renviron file. \strong{Most users
should NOT set \code{AWK_PATH}, only do so if you have installed AWK in
non-standard location and \code{auk} cannot find it.}
}
\examples{
\dontrun{
auk_set_awk_path("/usr/bin/awk")
}
}
\seealso{
Other paths: \code{\link{auk_get_awk_path}},
  \code{\link{auk_get_ebd_path}},
  \code{\link{auk_set_ebd_path}}
}
\concept{paths}
