% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals_trend}
\alias{check_residuals_trend}
\title{Checks for trend in residuals}
\usage{
check_residuals_trend(object, B = 20)
}
\arguments{
\item{object}{An object of class 'explainer' created with function \code{\link[DALEX]{explain}} from the DALEX package.}

\item{B}{number fo samplings}
}
\value{
standardized   loess fit for residuals
}
\description{
Calculates loess fit for residuals and then extracts statistics that shows how far is this fit from one without trend
}
\examples{
library(DALEX)
dragons <- DALEX::dragons[1:100, ]
lm_model <- lm(life_length ~ ., data = dragons)
lm_exp <- explain(lm_model, data = dragons, y = dragons$life_length)
library(auditor)
check_residuals_trend(lm_exp)
}
