% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResidual.R
\name{plotResidual}
\alias{plotResidual}
\title{Plot Residuals vs Observed, Fitted or Variable Values}
\usage{
plotResidual(object, ..., variable = NULL)
}
\arguments{
\item{object}{An object of class modelAudit.}

\item{...}{Other modelAudit objects to be plotted together.}

\item{variable}{Name of model variable to order residuals. If value is NULL data order is taken. If value is "Predicted response" or "Fitted values" then data is ordered by fitted values. If value is "Observed response" the data is ordered by a vector of actual response (\code{y} parameter passed to the \code{\link{audit}} function).}
}
\description{
A plot of residuals against fitted values, observed values or any variable.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotResidual(lm_au)

library(randomForest)
rf_model <- randomForest(prestige~education + women + income, data = Prestige)
rf_au <- audit(rf_model, data = Prestige, y = Prestige$prestige)
plotResidual(lm_au, rf_au)

}
\seealso{
\code{\link{plot.modelAudit}}
}
