% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.r
\name{auth}
\alias{auth}
\title{Authenticate for the  API}
\usage{
auth(
  user,
  password,
  domain = "https://bsky.app/",
  verbose = TRUE,
  overwrite = FALSE,
  token = NULL
)
}
\arguments{
\item{user}{Your user handle (e.g, benguinaudeau.bsky.social).}

\item{password}{Your app password (usually created on
\url{https://bsky.app/settings/app-passwords}).}

\item{domain}{For now https://bsky.app/, but could change in the future.}

\item{verbose}{Whether to print status messages to the Console
(\code{TRUE}/\code{FALSE}). Package default (when \code{NULL}) is to have
status messages. Can be changed with \code{Sys.setenv(ATR_VERBOSE =
  FALSE)}.}

\item{overwrite}{If TRUE, overwrites old token without asking for
confirmation.}

\item{token}{(Stale) token object. Usually you don't need to use this. But if
you manage your own tokens and they get stale, you can use this parameter
and request a fresh token.}
}
\value{
An authentication token (invisible)
}
\description{
Run authentication for a network using the AT protocol (e.g.,
\href{https://bsky.app/}{'Blue Sky'}) and save the token permanently.
}
\details{
After requesting the token, it is saved in the location returned by
\code{file.path(tools::R_user_dir("atrrr", "cache"), Sys.getenv("BSKY_TOKEN", unset = "token.rds"))}. If you have multiple tokens, you can use
\code{Sys.setenv(BSKY_TOKEN = "filename.rds")} to save/load the token with a
different name.
}
\examples{
\dontrun{
# request a token
auth() # this will guide you through all steps

# the token is stored in the location returned by this command
file.path(tools::R_user_dir("atrrr", "cache"),
          Sys.getenv("BSKY_TOKEN", unset = "token.rds"))

# to use a different than the default file name for the token, set BSKY_TOKEN
Sys.setenv(BSKY_TOKEN = "identity-2.rds")

# now either rename your token file or request a new token
auth()

# the cache now contains two tokens
list.files(tools::R_user_dir("atrrr", "cache"))

# functions that interact with the API also take a .token argument with the
# path. For example:
tok_path <- file.path(tools::R_user_dir("atrrr", "cache"), "identity-2.rds")
get_skeets_authored_by(actor = "benguinaudeau.bsky.social", parse = TRUE,
                       .token = tok_path)
}

}
