% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predicates.R
\name{is_uniq}
\alias{is_uniq}
\title{Returns TRUE where no elements appear more than once}
\usage{
is_uniq(..., allow.na = FALSE)
}
\arguments{
\item{...}{One or more vectors to check for unique combinations of elements}

\item{allow.na}{A logical indicating whether NAs should be preserved
as missing values in the return value (FALSE) or
if they should be treated just like any other value
(TRUE) (default is FALSE)}
}
\value{
A vector of the same length where the corresponding element
        is TRUE if the element only appears once in the vector and
        FALSE otherwise
}
\description{
This function is meant to take only a vector. It relies heavily on
the \code{\link{duplicated}} function where it can be thought of as
the inverse. Where this function differs, though--besides being only
meant for one vector or column--is that it marks the first occurrence
of a duplicated value as "non unique", as well.
}
\examples{

is_uniq(1:10)
is_uniq(c(1,1,2,3), c(1,2,2,3))

\dontrun{
# returns FALSE where a "5" appears
is_uniq(c(1:10, 5))
}

library(magrittr)

\dontrun{
# this fails 4 times
mtcars \%>\% assert(is_uniq, qsec)
}

# to use the version of this function that allows NAs in `assert`,
# you can use a lambda/anonymous function like so:

mtcars \%>\%
  assert(function(x){is_uniq(x, allow.na=TRUE)}, qsec)

}
\seealso{
\code{\link{duplicated}}
}
