% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-other.R, R/is-other.R
\name{assert_all_numbers_are_whole_numbers}
\alias{assert_all_are_whole_numbers}
\alias{assert_all_numbers_are_whole_numbers}
\alias{assert_any_are_whole_numbers}
\alias{assert_any_numbers_are_whole_numbers}
\alias{is_whole_number}
\title{Is the input a whole number?}
\usage{
assert_all_numbers_are_whole_numbers(x, tol = 100 * .Machine$double.eps)

assert_any_numbers_are_whole_numbers(x, tol = 100 * .Machine$double.eps)

assert_all_are_whole_numbers(x, tol = 100 * .Machine$double.eps)

assert_any_are_whole_numbers(x, tol = 100 * .Machine$double.eps)

is_whole_number(x, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{x}{Input to check.}

\item{tol}{Differences smaller than \code{tol} are not considered.}
}
\value{
\code{TRUE} if the input is a whole number.
}
\description{
Checks that the (probably floating point) input is a whole number.
}
\note{
The term whole number is used to distinguish from integer in
that the input \code{x} need not have type \code{integer}.  In fact
it is expected that \code{x} will be \code{numeric}.
}
\examples{
# 1, plus or minus a very small number
x <- 1 + c(0, .Machine$double.eps, -.Machine$double.neg.eps)
# By default, you get a bit of tolerance for rounding errors
is_whole_number(x)
# Set the tolerance to zero for exact matching.
is_whole_number(x, tol = 0)
}
\seealso{
\code{is_divisible_by}
}

