% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-base.R, R/is-type-base.R
\name{assert_is_externalptr}
\alias{assert_is_externalptr}
\alias{is_externalptr}
\title{Is the input is an external pointer?}
\usage{
assert_is_externalptr(x, severity = getOption("assertive.severity", "stop"))

is_externalptr(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_externalptr} wraps \code{is.data.frame}, 
providing more information on failure.  \code{assert_is_externalptr} 
returns nothing but throws an error if \code{is_externalptr} 
returns \code{FALSE}.
}
\description{
Check whether the input is an external pointer. that is, an object of
class (\code{"externalptr"}).
}
\examples{
# The xml2 pkg makes heavy use of external pointers
xptr <- xml2::read_xml("<foo><bar /></foo>")$node
assert_is_externalptr(xptr)

# This should fail
assertive.base::dont_stop({
assert_is_externalptr(NULL)
})
}

