% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-has-slot.R, R/has-slot.R
\name{assert_has_slot}
\alias{assert_has_slot}
\alias{has_slot}
\title{Does the S4 input have a slot?}
\usage{
assert_has_slot(x, severity = getOption("assertive.severity", "stop"))

has_slot(x, slotname, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.  Intended to be an S4 object.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{slotname}{A string naming a slot to check for.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{has_names} returns \code{TRUE} if \code{names} is 
non-null.
}
\description{
Checks to see if the object is an S4 object with a particular slot.
}
\examples{
setClass("numbers", representation(foo = "numeric"))
x <- new("numbers", foo = 1:10)
has_slot(x, "foo")
has_slot(x, "bar")
has_slot(1:10, "foo")
}
\seealso{
\code{\link[methods]{slot}}
}
