% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are-identical.R, R/assert-are-identical.R
\name{are_identical}
\alias{are_identical}
\alias{are_identical_legacy}
\alias{assert_are_identical}
\alias{assert_all_are_identical_legacy}
\alias{assert_any_are_identical_legacy}
\title{Are the inputs identical?}
\usage{
are_identical(
  x,
  y,
  allow_attributes = FALSE,
  .xname = get_name_in_parent(x),
  .yname = get_name_in_parent(y)
)

are_identical_legacy(..., l = list())

assert_are_identical(
  x,
  y,
  allow_attributes = FALSE,
  severity = getOption("assertive.severity", "stop")
)

assert_all_are_identical_legacy(..., l = list())

assert_any_are_identical_legacy(..., l = list())
}
\arguments{
\item{x}{An R object or expression.}

\item{y}{Another R object or expression.}

\item{allow_attributes}{If \code{TRUE}, The attributes of \code{x} and 
\code{y} are allowed to differ.}

\item{.xname}{Not intended to be used directly.}

\item{.yname}{Not intended to be used directly.}

\item{...}{Some R expressions, deprecated.}

\item{l}{A list of R expressions, deprecated.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{are_identical} returns \code{TRUE} if \code{x} and \code{y} 
are identical.  The \code{assert_*} function throws an error on failure.

The legacy function \code{are_identical_legacy} allows an arbitrary number
of inputs and returns a symmetric square logical matrix which is \code{TRUE} 
where pairs of inputs are identical.  (The new version of the function 
is easier to work with, and it is recommended that you switch your code to 
it.)
}
\description{
Checks if the inputs are identical.
}
\examples{
x <- 1:5
are_identical(c(1, -1), cos(c(0, pi)))
assertive.base::dont_stop(assert_are_identical(c(1, 1), cos(c(0, pi))))
}
\seealso{
\code{\link[base]{identical}}, 
\code{\link[assertive.properties]{are_same_length}}
}
