% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_includes.R
\name{assert_includes}
\alias{assert_includes}
\title{Assert object includes required}
\usage{
assert_includes(
  x,
  required,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object}

\item{required}{The required elements to check for}

\item{msg}{A character string describing the error message if \code{x} does not include \code{required} elements}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} includes all \code{required} elements, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert x includes required elements
}
\examples{
try({
assert_directory(system.file("package = assertions"))
assert_directory("foo") # Throws Error
})

}
\concept{assert_includes}
