% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_flag}
\alias{assert_flag}
\title{Assert input is a scalar logical}
\usage{
assert_flag(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not a scalar logical}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is a scalar logical, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert input is a flag (a logical of length 1: \code{TRUE} or \code{FALSE})
}
\examples{
try({
assert_flag(TRUE) # Passes
assert_flag(FALSE) # Passes
assert_flag(c(TRUE, FALSE)) # Throws default error
assert_flag(1, "Custom error message") # Throws custom error
})


}
\concept{assert_type}
