% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svg.R
\name{write_svg}
\alias{write_svg}
\title{Create animated SVG from an asciicast}
\usage{
write_svg(
  cast,
  path,
  window = NULL,
  start_at = NULL,
  end_at = NULL,
  at = NULL,
  cursor = NULL,
  rows = NULL,
  cols = NULL,
  padding = NULL,
  padding_x = NULL,
  padding_y = NULL,
  omit_last_line = NULL,
  theme = NULL
)
}
\arguments{
\item{cast}{\code{asciicast} object.}

\item{path}{Path to the SVG file to create.}

\item{window}{Render with window decorations.}

\item{start_at}{Lower range of timeline to render in seconds.}

\item{end_at}{Upper range of timeline to render in seconds.}

\item{at}{Timestamp of single frame to render, in seconds. Alternatively
it can be \code{"end"}, to take a snapshot at the end of the cast, after
all output is done.}

\item{cursor}{Enable cursor rendering.}

\item{rows}{Height in lines.}

\item{cols}{Width in columns.}

\item{padding}{Distance between text and image bounds.}

\item{padding_x}{Distance between text and image bounds on x axis.}

\item{padding_y}{Distance between text and image bounds on y axis.}

\item{omit_last_line}{Whether to omit the last line of the cast. This
often just the prompt, and sometimes it is not worth showing.}

\item{theme}{A named list to override the default theme
(see \code{\link[=default_theme]{default_theme()}}).}
}
\description{
Create animated SVG from an asciicast
}
\examples{
\dontshow{if (!asciicast:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cast <- read_cast(system.file("examples", "hello.cast", package = "asciicast"))
svg_file <- tempfile(fileext = ".svg")
write_svg(cast, svg_file)
\dontshow{unlink(svg_file, recursive = TRUE)}
\dontshow{\}) # examplesIf}
}
\seealso{
Other SVG functions: 
\code{\link{default_theme}()},
\code{\link{play}()}
}
\concept{SVG functions}
