% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gif.R
\name{write_gif}
\alias{write_gif}
\title{Export ascii screencast to animated GIF file}
\usage{
write_gif(
  cast,
  path,
  show = NULL,
  cols = NULL,
  rows = NULL,
  theme = NULL,
  scale = 2,
  speed = 1,
  max_colors = 256,
  loop = 0,
  end_wait = 10,
  optimize = TRUE
)
}
\arguments{
\item{cast}{\code{asciicast} object.}

\item{path}{Path to GIF file to create.}

\item{show}{Whether to show the GIF on the screen, in the viewer pane
in RStudio, or using the image viewer in the magick package.
By default it only show the image in RStudio.}

\item{cols}{If not \code{NULL}, \emph{clip} terminal width to this number of
columns.}

\item{rows}{If not \code{NULL}, \emph{clip} terminal height to this number of
rows.}

\item{theme}{Theme. Currently supported themes: asciinema, tango,
solarized-dark, solarized-light, monokai. Defaults to the theme
specified in the cast, or asciiname if not specified.}

\item{scale}{Image scale / pixel density.}

\item{speed}{Playback speed. Higher number means faster.}

\item{max_colors}{Maximum number of colors in the GIF. This is
currently per frame.}

\item{loop}{How many times to loop the animation. Zero means infinite
loop.}

\item{end_wait}{Number of seconds to wait at the end, before looping.}

\item{optimize}{Whether to try to create smaller GIF files. This might
be slow for casts with many frames.}
}
\value{
\code{path}, invisibly.
}
\description{
Export ascii screencast to animated GIF file
}
