% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LUCS_KDD_CBA.R
\name{LUCS_KDD_CBA}
\alias{LUCS_KDD_CBA}
\alias{FOIL2}
\alias{CPAR}
\alias{PRM}
\alias{CMAR}
\title{Interface to the LUCS-KDD Implementations of CMAR, PRM and CPAR}
\usage{
FOIL2(formula, data, best_k = 5, disc.method = "mdlp", verbose = FALSE)

CPAR(formula, data, best_k = 5, disc.method = "mdlp", verbose = FALSE)

PRM(formula, data, best_k = 5, disc.method = "mdlp", verbose = FALSE)

CMAR(
  formula,
  data,
  support = 0.1,
  confidence = 0.5,
  disc.method = "mdlp",
  verbose = FALSE
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fitted. Has to be
of form `class ~ .` or `class ~ predictor1 + predictor2`.}

\item{data}{A data.frame or a transaction set containing the training data.
Data frames are automatically discretized and converted to transactions.}

\item{best_k}{use average expected accuracy (laplace) of the best k rules
per class for prediction.}

\item{disc.method}{Discretization method used to discretize continuous
variables if data is a data.frame (default: `"mdlp"`). See
[discretizeDF.supervised()] for more supervised discretization
methods.}

\item{verbose}{Show verbose output?}

\item{support, confidence}{minimum support and minimum confidence thresholds
for CMAR (range [0, 1]).}
}
\value{
Returns an object of class [CBA.object]] representing the
trained classifier.
}
\description{
Interface for the LUCS-KDD Software Library Java implementations of CMAR
(Li, Han and Pei, 2001), PRM, and CPAR (Yin and Han, 2003). **Note:** The
Java implementations is not part of \pkg{arulesCBA} and
is only free for **non-commercial use**.
}
\details{
**Requirement:** The code needs a
**JDK (Java Software Development Kit) Version 1.8 (or higher)**
installation. A **headless Java installation is not sufficient.**
On some systems (Windows),
you may need to set the `JAVA_HOME` environment variable so the system
finds the compiler.

**Memory:** The memory for Java can be increased via R options. For
example: `options(java.parameters = "-Xmx1024m")`

**Note:** The implementation does not expose the min. gain parameter for
CPAR, PRM and FOIL2. It is fixed at 0.7 (the value used by Yin and Han,
2001). FOIL2 is an alternative Java implementation to the native
implementation of FOIL already provided in the \pkg{arulesCBA}.
[FOIL] exposes min. gain.
}
\examples{
# make sure you have a Java SDK Version 1.4.0+ and not a headless installation.
system("java -version")

data("iris")

# build a classifier, inspect rules and make predictions
cl <- CMAR(Species ~ ., iris, support = .2, confidence = .8, verbose = TRUE)
cl

inspect(rules(cl))
predict(cl, head(iris))

cl <- CPAR(Species ~ ., iris)
cl

cl <- PRM(Species ~ ., iris)
cl

cl <- FOIL2(Species ~ ., iris)
cl
}
\references{
Li W., Han, J. and Pei, J. CMAR: Accurate and Efficient
Classification Based on Multiple Class-Association Rules, ICDM, 2001, pp.
369-376.

Yin, Xiaoxin and Jiawei Han. CPAR: Classification based on Predictive
Association Rules, SDM, 2003.
\doi{10.1137/1.9781611972733.40}

Frans Coenen et al. The LUCS-KDD Software Library,
\url{https://cgi.csc.liv.ac.uk/~frans/KDD/Software/}
}
