% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitions.R
\docType{data}
\name{Partitions}
\alias{Partitions}
\alias{ipartitions}
\title{Partitions iterator}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
Partitions

ipartitions(n, k = NULL, descending = FALSE)
}
\arguments{
\item{n}{an non-negative integer to be partitioned}

\item{k}{number of parts}

\item{descending}{logical to use reversed lexicographical order}
}
\description{
This function returns a \href{Partitions-class.html}{Partitions} iterator which
allows users to fetch the next partition(s) via the \code{getnext()} method. All remaing
partitions of the iterator can be fetched via the \code{collect()} method.
}
\details{
The \code{Partitions} class can be initialized by using the convenient wrapper \code{ipartitions} or
\preformatted{
Partitions$new(n, k = NULL, descending = FALSE)
}

\preformatted{
getnext(d = 1L, type = NULL, drop = d == 1L && is.null(type))
collect(type = "r")
reset()
}
\describe{
\item{d}{number of fetched arrangements}

\item{type}{if "r", "c" or "l" is specified, the returned value would be a
 "row-major" matrix, a "column-major" matrix or a list respectively}

\item{drop}{vectorize a matrix or unlist a list}
}
}
\examples{
ipart <- ipartitions(10)
ipart$getnext()
ipart$getnext(2)
ipart$getnext(type = "c", drop = FALSE)
# collect remaining partitions
ipart$collect()

library(foreach)
foreach(x = ipartitions(6, 2), .combine=c) \%do\% {
  prod(x)
}
}
\seealso{
\link{partitions} for generating all partitions and \link{npartitions} to calculate number of partitions
}
\keyword{datasets}
