% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/archive_extract.R
\name{archive_extract}
\alias{archive_extract}
\title{Extract contents of an archive to a directory}
\usage{
archive_extract(archive, dir = ".", file = NULL, options = character())
}
\arguments{
\item{archive}{\code{character(1)} The archive filename or an \code{archive} object.}

\item{dir}{\code{character(1)} Directory location to extract archive contents, will be created
if it does not exist.}

\item{file}{\code{character(1) || integer(1)} The filename within the archive,
specified either by filename or by position.}

\item{options}{\code{character()} default: \code{character(0)} Options to pass to the filter or format.
The list of available options are documented in
options can have one of the following forms:
\itemize{
\item \code{option=value}
The option/value pair will be provided to every module.
Modules that do not accept an option with this name will
ignore it.
\item \code{option}
The option will be provided to every module with a value
of "1".
\item \code{!option}
The option will be provided to every module with a NULL
value.
\item \code{module:option=value}, \code{module:option}, \code{module:!option}
As above, but the corresponding option and value will be
provided only to modules whose name matches module.
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_read_set_options&sektion=3&format=html}{read options} for available read options
See \href{https://www.freebsd.org/cgi/man.cgi?query=archive_write_set_options&sektion=3&format=html}{write options} for available write options
}}
}
\value{
An 'archive' object describing the archive (invisibly).
}
\description{
Extract contents of an archive to a directory
}
\details{
If \code{file} is \code{NULL} (the default) all files will be extracted.
}
\examples{
a <- archive(system.file(package = "archive", "extdata", "data.zip"))
d <- tempfile()

# When called with default arguments extracts all files in the archive.
archive_extract(a, d)
list.files(d)
unlink(d)

# Can also specify one or more files to extract
d <- tempfile()
archive_extract(a, d, c("iris.csv", "airquality.csv"))
list.files(d)
unlink(d)
}
