% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-geometry.R
\name{determine_esri_geo_type}
\alias{determine_esri_geo_type}
\title{Determine Esri Geometry type}
\usage{
determine_esri_geo_type(x)
}
\arguments{
\item{x}{an object of class \code{data.frame}, \code{sf}, \code{sfc}, or \code{sfg}.}
}
\value{
returns a character scalar of the corresponding Esri geometry type
}
\description{
Takes an \code{sf} or \code{sfc} object and returns the appropriate Esri geometry type.
}
\details{
\subsection{Geometry type mapping}{
\itemize{
\item \code{POINT}:  \code{esriGeometryPoint}
\item \code{MULTIPOINT}:  \code{esriGeometryMultipoint}
\item \code{LINESTRING}:  \code{esriGeometryPolyline}
\item \code{MULTILINESTRING}:  \code{esriGeometryPolyline}
\item \code{POLYGON}:  \code{esriGeometryPolygon}
\item \code{MULTIPOLYGON}:  \code{esriGeometryPolygon}
}
}
}
\examples{
determine_esri_geo_type(sf::st_point(c(0, 0)))
}
