% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzOffset.R
\name{hzAbove}
\alias{hzAbove}
\alias{hzBelow}
\alias{hzOffset}
\title{Horizons Above or Below}
\usage{
hzAbove(x, ..., offset = 1, SPC = TRUE, simplify = SPC)

hzBelow(x, ..., offset = 1, SPC = TRUE, simplify = SPC)

hzOffset(x, hzid, offset, SPC = FALSE, simplify = TRUE)
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{...}{Comma-separated set of R expressions that evaluate as \code{TRUE} or \code{FALSE} in context of horizon data frame. Length for individual expressions matches number of horizons, in \code{x}.}

\item{offset}{Integer offset in terms of SoilProfileCollection \verb{[,j]} (horizon/slice) index}

\item{SPC}{Return a SoilProfileCollection? Default \code{TRUE} for \verb{horizon_*} methods.}

\item{simplify}{If \code{TRUE} return a vector (all elements combined), or a list (1 element per profile). If \code{SPC} is \code{TRUE} then \code{simplify} is \code{TRUE}.}

\item{hzid}{A vector of target horizon IDs. These are calculated from \code{...} for \verb{horizon_*()} methods}
}
\value{
A SoilProfileCollection (when \code{SPC = TRUE}) or a vector of horizon row indices (when \code{SPC = FALSE} and \code{simplify = TRUE}) or a list (when \code{SPC = FALSE} and \code{simplify = FALSE}))
}
\description{
Horizons Above or Below
}
\details{
To minimize likelihood of issues with non-standard evaluation context, especially when using \code{hzAbove()}/\code{hzBelow()} inside another function, all expressions used in \code{...} should be in terms of variables that are in the horizon data frame.
}
\examples{
data(sp4)
depths(sp4) <- id ~ top + bottom

# get the horizon above the last horizon (j-index of bottom horizon minus 1)
hzAbove(sp4, hzID(sp4) \%in\% getLastHorizonID(sp4))

# get horizons below the last horizon (none; j-index of bottom horizon plus 1)
hzBelow(sp4, hzID(sp4) \%in\% getLastHorizonID(sp4))

}
