% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-methods.R
\name{subset,SoilProfileCollection-method}
\alias{subset,SoilProfileCollection-method}
\alias{subset}
\title{Subset a SoilProfileCollection with logical expressions}
\usage{
\S4method{subset}{SoilProfileCollection}(x, ..., greedy = FALSE)
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{...}{Comma-separated set of R expressions that evaluate as TRUE or FALSE. Length for individual expressions matches number of sites OR number of horizons, in \code{object}.}

\item{greedy}{Use "greedy" matching for combination of site and horizon level matches? \code{greedy = TRUE} is the union, whereas \code{greedy = FALSE} (default) is the intersection (of site and horizon matches).}
}
\value{
A SoilProfileCollection.
}
\description{
\code{subset()} is a function used for subsetting SoilProfileCollections. It allows the user to specify an arbitrary number of logical vectors (equal in length to site or horizon), separated by commas. The function includes some support for non-standard evaluation found in the \code{tidyverse}. This greatly simplifies access to site and horizon-level variable compared to \code{subset.default}, as \code{`$`} or \code{`[[`} methods are not needed.
}
\details{
In base R, the method that performs extraction based on a set of expressions is \code{subset}, so this is the "default" name in the AQP package. The \code{filter} method is defined in the base R \code{stats} package for linear filtering of time series.
}
\seealso{
\code{\link{filter}}
}
\author{
Andrew G. Brown.
}
