% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/munsell2rgb.R
\name{munsell2spc,SoilProfileCollection-method}
\alias{munsell2spc,SoilProfileCollection-method}
\alias{munsell2spc}
\title{Merge Munsell Hue, Value, Chroma converted to RGB & LAB into a SoilProfileCollection}
\usage{
\S4method{munsell2spc}{SoilProfileCollection}(
  object,
  hue = "hue",
  value = "value",
  chroma = "chroma",
  as.spc = TRUE
)
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{hue}{Column name containing numeric hue values. Default: \code{"hue"}}

\item{value}{Column name containing numeric value values. Default: \code{"value"}}

\item{chroma}{Column name containing numeric chroma values. Default: \code{"chroma"}}

\item{as.spc}{Return a data.frame-like object with ID columns?}
}
\value{
A SoilProfileCollection or \code{data.frame}-like object
}
\description{
Convert Munsell hue, value and chroma into [R, G, B] and [L, A, B] color coordinates using \code{munsell2rgb}. The converted values are stored in the \code{horizons()} slot unless \code{as.spc} is \code{FALSE}, in which case the results are combined with profile and horizon ID columns and returned as the \code{data.frame} subclass used by the SPC.
}
\examples{

data(sp3)
depths(sp3) <- id ~ top + bottom

# inspect input data
horizons(sp3)[,c("hue","value","chroma")]

# do color conversions to RGB and LAB, join into horizon data
sp3 <- munsell2spc(sp3)

# plot rgb "R" coordinate by horizon
plot(sp3, color = "rgb_R")

# plot lab "A" coordinate by horizon
plot(sp3, color = "lab_A")

}
