% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_choiceAnalysis.R
\name{apollo_choiceAnalysis}
\alias{apollo_choiceAnalysis}
\title{Reports market share for subsamples}
\usage{
apollo_choiceAnalysis(choiceAnalysis_settings, apollo_inputs)
}
\arguments{
\item{choiceAnalysis_settings}{List containing settings for this function. The settings must be:
\itemize{
  \item alternatives: Named numeric vector. Names of alternatives and their corresponding value in \code{choiceVar}.
  \item avail: Named list of numeric vectors or scalars. Availabilities of alternatives, one element per alternative. Names of elements must match those in \code{alternatives}. Values can be 0 or 1.
  \item choiceVar: Numeric vector. Contains choices for all observations. It will usually be a column from the database. Values are defined in \code{alternatives}.
  \item explanators: data.frame. Variables determining subsamples of the database. Values in each column must describe a group or groups of individuals (e.g. socio-demographics). Most usually a subset of columns from database.
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
nothing, but prints the output to screen and writes a csv file to the working directory.
}
\description{
Compares market shares across subsamples in dataset, and writes results to a file.
}
\details{
Saves the output to a csv file in the working directory.
}
