% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_adjust-print.R
\name{print.predict_adjust}
\alias{print.predict_adjust}
\title{Print \code{predict_adjust} object}
\usage{
\method{print}{predict_adjust}(x, ...)
}
\arguments{
\item{x}{An \code{predict_adjust} object produced by the
\code{\link[api2lm]{predict_adjust}} function.}

\item{...}{Additional arguments to the
\code{\link[base]{print.default}} function, such as
\code{digits}.}
}
\value{
Depending on the \code{interval} argument of
\code{\link[api2lm]{predict_adjust}}:

A vector of predictions if \code{interval = "none"}.

A matrix of predictions and bounds with column names
\code{fit}, \code{lwr}, and \code{upr} if
\code{interval} is set. For \code{type = "terms"} this
is a matrix with a column per term and may have an
attribute \code{"constant"}.

If \code{se.fit} is \code{TRUE}, a
list with the following components is returned:
\itemize{
 \item{\code{fit}}{: vector or matrix as above}
 \item{\code{se.fit}}{: standard error of predicted means}
 \item{\code{residual.scale}}{: residual standard deviations}
 \item{\code{df}}{: degrees of freedom for residual}
}
}
\description{
Print an object of class \code{predict_adjust} produced
by the \code{\link[api2lm]{predict_adjust}} function.
}
\examples{
fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
(cia <- predict_adjust(fit))
print(cia, digits = 3)
}
\author{
Joshua French
}
