% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labs.R
\name{ax_labs}
\alias{ax_labs}
\title{Modify axis, legend, and chart labels}
\usage{
ax_labs(ax, title = NULL, subtitle = NULL, x = NULL, y = NULL)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{title}{Text for the title.}

\item{subtitle}{Text for the subtitle.}

\item{x}{Text for the x-axis label.}

\item{y}{Text for the y-axis label.}
}
\description{
Modify axis, legend, and chart labels
}
\examples{
meteo_paris <- data.frame(
  month = month.name,
  tmax = c(7, 8, 12, 15, 19, 23, 25, 25, 21, 16, 11, 8),
  tmin = c(3, 3, 5, 7, 11, 14, 16, 16, 13, 10, 6, 3)
)

apex(meteo_paris, type = "column", aes(x = month, y = tmin)) \%>\%
  ax_labs(
    title = "Average minimal temperature in Paris",
    subtitle = "Data from NOAA",
    x = "Month",
    y = "Temperature (\u00b0C)"
  )
}
