% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiphyDat.constructor.R
\docType{methods}
\name{initialize,multiphyDat-method}
\alias{initialize,multiphyDat-method}
\alias{initialize,multiphyDat-methods}
\alias{new.multiphyDat}
\title{multiphyDat constructor}
\usage{
\S4method{initialize}{multiphyDat}(.Object, seq = NULL, type = character(0),
  ind.info = NULL, gene.info = NULL, add.gaps = TRUE, quiet = FALSE,
  ...)
}
\arguments{
\item{.Object}{the object skeleton, automatically generated when calling \code{new}.}

\item{seq}{a list of phyDat matrices (1 per gene); rows should be labelled and indicate individuals, but different individuals and different orders can be used in different matrices.}

\item{type}{a character string indicating the type of the sequences stored: "DNA" for DNA sequences, "AA" for amino-acids.}

\item{ind.info}{an optional data.frame containing information on the individuals, where individuals are in rows.}

\item{gene.info}{an optional data.frame containing information on the genes, where genes are in rows.}

\item{add.gaps}{a logical indicating if gap-only sequences should be used where sequences are missing; defaults to TRUE.}

\item{quiet}{a logical indicating if messages should be shown; defaults to FALSE.}

\item{...}{further arguments to be passed to other methods}
}
\description{
New \linkS4class{multiphyDat} objects can be created using \code{new("multiphyDat", ...)} where "..." are arguments documented below.
The main input is a list of phyDat matrices. The constructor ensures that all matrices will be reordered in the same way, and genes with missing individuals will be filled by sequences of gaps ("-").
}
\examples{
data(Laurasiatherian)
#' ## empty object
new("multiphyDat")

## simple conversion with nicely ordered output
\dontrun{
genes <- list(gene1=subset(Laurasiatherian,, 1:1600, FALSE),
    gene2=subset(Laurasiatherian,, 1601:3179, FALSE))
x <- new("multiphyDat", genes)
x
}

## trickier conversion with missing sequences / wrong order
genes <- list(gene1=subset(Laurasiatherian, 1:40),
    gene2=subset(Laurasiatherian, 8:47))
x <- new("multiphyDat", genes)
x

}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}

Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\seealso{
\itemize{
\item the \linkS4class{multiphyDat} class
\item \code{\link{read.multiphyDat}}
}
}

