% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/exports.R
\docType{methods}
\name{multidna2genind}
\alias{multidna2genind}
\alias{multiphyDat2genind}
\title{Convert multidna into genind}
\usage{
multidna2genind(x, genes = TRUE, mlst = FALSE, gapIsNA = FALSE)

multiphyDat2genind(x, genes = TRUE, mlst = FALSE, gapIsNA = FALSE)
}
\arguments{
\item{x}{a \linkS4class{multidna} or \linkS4class{multiphyDat} object.}

\item{genes}{an optional vector indicating the genes to retain for the concatenation; any way to subset the list in x@dna or x@seq is acceptable; by default, all genes are used.}

\item{mlst}{if \code{TRUE}, each gene will result in a single locus in the genind object. (Default to \code{FALSE})}

\item{gapIsNA}{if \code{TRUE} and \code{mlst = TRUE}, sequences that consist entirely of gaps will be considered as NAs. (Default to \code{FALSE})}
}
\value{
a \linkS4class{genind} object
}
\description{
The functions \code{multidna2genind} and \code{multiphyDat2genind} concatenates separate DNA alignments, and then extracts SNPs of the resulting alignment into a \linkS4class{genind} object.
}
\examples{
## simple conversion with nicely ordered output
data(woodmouse)
genes <- list(gene1=woodmouse[,1:500], gene2=woodmouse[,501:965])
x <- new("multidna", genes)
x
y <- multidna2multiphyDat(x)
y
z1 <- multidna2genind(x)
z1
z2 <- multiphyDat2genind(y)
all.equal(z1, z2)
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}, Zhian N. Kamvar, Klaus Schliep
}
\seealso{
\itemize{
\item concatenate
\item \code{\link{DNAbin2genind}} to convert single DNAbin objects.
}
}

