% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/accessors.R
\docType{methods}
\name{accessors}
\alias{accessors}
\alias{getNumLoci}
\alias{getNumLoci,multidna-method}
\alias{getNumSequences}
\alias{getNumSequences,multidna}
\alias{getNumSequences,multidna-method}
\alias{getSequenceNames}
\alias{getSequenceNames,multidna}
\alias{getSequenceNames,multidna-method}
\alias{getSequences}
\alias{getSequences,multidna}
\alias{getSequences,multidna-method}
\alias{locusNames}
\alias{locusNames,multidna}
\alias{locusNames,multidna-method}
\alias{locusNames<-}
\alias{locusNames<-,multidna}
\alias{locusNames<-,multidna-method}
\title{multidna Accessors}
\usage{
getNumLoci(x, ...)

\S4method{getNumLoci}{multidna}(x, ...)

locusNames(x, ...)

\S4method{locusNames}{multidna}(x, ...)

locusNames(x) <- value

\S4method{locusNames}{multidna}(x) <- value

getNumSequences(x, ...)

\S4method{getNumSequences}{multidna}(x, gap.only = FALSE, loci = NULL, ...)

getSequenceNames(x, ...)

\S4method{getSequenceNames}{multidna}(x, gap.only = FALSE, loci = NULL, ...)

getSequences(x, ...)

\S4method{getSequences}{multidna}(x, loci = NULL, ids = NULL,
  simplify = TRUE, exclude.gap.only = TRUE, ...)
}
\arguments{
\item{x}{a \linkS4class{multidna} object.}

\item{...}{further arguments passed on to other functions.}

\item{value}{a replacement value for the slot.}

\item{gap.only}{logical. Return information only for sequences containing
all gaps?}

\item{loci}{a character, numeric, or logical vector identifying which
loci to return.}

\item{ids}{a character, numeric, or logical vector identifying which
sequences to return within a locus.}

\item{simplify}{logical. If \code{FALSE}, always return a list of
DNAbin sequences. If \code{TRUE} and only one locus has been requested,
return a single DNAbin object.}

\item{exclude.gap.only}{logical. Remove sequences containing all gaps?}
}
\description{
Accessors for slots in \linkS4class{multidna} objects.
}
\details{
\describe{
  \item{getNumLoci}{Returns the number of loci.}
  \item{locusNames}{Returns or sets the names of each locus.}
  \item{getNumSequences}{Returns the number of sequences in each locus.}
  \item{getSequenceNames}{Returns the names of individual sequences at each
    locus.}
  \item{getSequences}{Returns sequences of specified loci and individuals.}
}
}

