% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apaDvalueTable.R
\name{apa.d.table}
\alias{apa.d.table}
\title{Creates a d-values for all paired comparisons in APA style}
\usage{
apa.d.table(iv, dv, data, filename = NA, table.number = NA,
  show.conf.interval = TRUE, landscape = TRUE)
}
\arguments{
\item{iv}{Name of independent variable column in data frame for all paired comparisons}

\item{dv}{Name of dependent variable column in data frame for all paired comparisons}

\item{data}{Project data frame name}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}

\item{show.conf.interval}{(TRUE/FALSE) Display confidence intervals in table.}

\item{landscape}{(TRUE/FALSE) Make RTF file landscape}
}
\value{
APA table object
}
\description{
Creates a d-values for all paired comparisons in APA style
}
\examples{
# View top few rows of viagra data set from Discovering Statistics Using R
head(viagra)

# Use apa.d.table function
apa.d.table(iv=dose,dv=libido,data=viagra,filename="ex1_d_table.doc")
}

