% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/apaRegressionTable.R
\name{apa.reg.table}
\alias{apa.reg.table}
\title{Creates a regresion table in APA style}
\usage{
apa.reg.table(..., filename = NA, table.number = NA)
}
\arguments{
\item{...}{Regression (i.e., lm) result objects. Typically, one for each block in the regression.}

\item{filename}{(optional) Output filename document filename (must end in .rtf or .doc only)}

\item{table.number}{Integer to use in table number output line}
}
\value{
APA table object
}
\description{
Creates a regresion table in APA style
}
\examples{
# View top few rows of goggles data set
# from Discovering Statistics Using R
head(album)

# Single block example
block1 <- lm(sales ~ adverts + airplay, data=album)
apa.reg.table(block1)
apa.reg.table(block1,filename="exRegTable.doc")

# Two block example
block1 <- lm(sales ~ adverts, data=album)
block2 <- lm(sales ~ adverts + airplay + attract, data=album)
apa.reg.table(block1,block2,filename="exRegBlocksTable.doc")

# More than two blocks can be used if desired
}

