# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

anytime_cpp <- function(x, tz = "UTC", asUTC = FALSE, asDate = FALSE, useR = FALSE, oldHeuristic = FALSE) {
    .Call(anytime_anytime_cpp, x, tz, asUTC, asDate, useR, oldHeuristic)
}

#' The time and date parsing and conversion relies on trying a (given
#' and fixed) number of timeformats. The format used is the one employed
#' by the underlying implementation of the Boost date_time library.
#'
#' @title Functions to retrieve (or set) formats used for parsing dates.
#' @param fmt A vector of character values in the form understood by Boost
#' date_time
#' @return Nothing in the case of \code{addFormats}; a character vector of
#' formats in the case of \code{getFormats}
#' @seealso \code{\link{anytime-package}} and references therein
#' @author Dirk Eddelbuettel
#' @examples
#'   getFormats()
#'   addFormats(c("%d %b %y",      # two-digit date [not recommended], textual month
#'                "%a %b %d %Y"))  # weekday weeknumber four-digit year
getFormats <- function() {
    .Call(anytime_getFormats)
}

#' @rdname getFormats
addFormats <- function(fmt) {
    invisible(.Call(anytime_addFormats, fmt))
}

testFormat_impl <- function(fmt, s, tz = "") {
    .Call(anytime_testFormat_impl, fmt, s, tz)
}

testOutput_impl <- function(fmt, s) {
    .Call(anytime_testOutput_impl, fmt, s)
}

setDebug <- function(mode) {
    .Call(anytime_setDebug, mode)
}

format <- function(x) {
    .Call(anytime_format, x)
}

setMaxIntAsYYYYMMDD <- function(val) {
    invisible(.Call(anytime_setMaxIntAsYYYYMMDD, val))
}

setMaxIntAsDate <- function(val) {
    invisible(.Call(anytime_setMaxIntAsDate, val))
}

setInitialTZ <- function(tz) {
    invisible(.Call(anytime_setInitialTZ, tz))
}

