#Copyright © 2016 RTE Réseau de transport d’électricité

context("Setup functions")

sapply(studyPathS, function(studyPath){
  
suppressPackageStartupMessages(require(lubridate))
suppressWarnings(suppressPackageStartupMessages(require(data.table)))

# Reading of study options #####################################################

trueOpts <- list(
  studyName = "Test_packages_R",
  name = "test",
  mode = "Economy",
  synthesis = TRUE,
  yearByYear = TRUE,
  scenarios = TRUE,
  mcYears = c(1,2),
  antaresVersion = if (basename(dirname(studyPath)) == "v6") 600L else 700L,
  timeIdMin = (firstDay-1) * 24 + 1,
  timeIdMax = lastDay*24,
  start = as.POSIXlt("2018-01-01", tz = "UTC"),
  firstWeekday = "Monday",
  areaList = c("a", "a_offshore", "b", "c", "hub", "psp in", "psp in-2", "psp out", 
               "psp out-2"),
  districtList = "a and b",
  linkList = c("a - a_offshore", "a - b", "a - psp in", "a - psp out", "b - c", 
               "b - psp in", "b - psp out", "c - hub", "hub - psp in-2", 
               "hub - psp out-2"),
  areasWithClusters = c("a", "b", "c", "psp in", "psp in-2", "psp out", "psp out-2"),
  districtsDef = data.table(district = as.factor("a and b"), area = as.factor(c("a", "b")))
)

test_that("setSimulationPath reads correct values", {
  opts <- setSimulationPath(studyPath)
  expect_equal(opts[names(trueOpts)], trueOpts)
})

test_that("R option 'antares' is set", {
  opts <- setSimulationPath(studyPath)
  expect_identical(opts, getOption("antares"))
})
opts <- setSimulationPath(studyPath)
if(!isH5Opts(opts))
{
test_that("setSimulationPath fails if path is not an antares Ouput directory", {
  expect_error(setSimulationPath(file.path(studyPath, "../..")))
})
}

opts <- setSimulationPath(studyPath)
if(!isH5Opts(opts))
{
test_that("setSimulationPath can read info in input", {
  opts <- setSimulationPath(studyPath, "input")
  for (v in c("studyName", "areaList", "districtList", "linkList",
              "areasWithClusters", "timeIdMin", "timeIdMax", "start", 
              "firstWeekday")) {
    expect_equal(opts[[v]], trueOpts[[v]])
  }
})

test_that("setSimulationPath works if synthesis and some MC years are not saved (#31)", {
  opts <- setSimulationPath(studyPath)
  
  file.rename(file.path(opts$simDataPath, "mc-all"), 
              file.path(opts$simDataPath, "mc-all_back"))
  file.rename(file.path(opts$simDataPath, "mc-ind/00001"), 
              file.path(opts$simDataPath, "mc-ind/00001_back"))
  
  opts <- setSimulationPath(studyPath)
  trueOpts$synthesis <- FALSE
  trueOpts$mcYears <- 2
  expect_equal(opts[names(trueOpts)], trueOpts)
  
  file.rename(file.path(opts$simDataPath, "mc-all_back"), 
              file.path(opts$simDataPath, "mc-all"))
  file.rename(file.path(opts$simDataPath, "mc-ind/00001_back"), 
              file.path(opts$simDataPath, "mc-ind/00001"))
})

# Simulation selection #########################################################

# test_that("Interactive mode if no study path provided", {
#   skip_if_not(exists("choose.dir", getNamespace("utils")))
#   with_mock(
#     `utils::choose.dir` = function(...) {studyPath},
#     {
#       opts <- setSimulationPath()
#       expect_equal(opts[names(trueOpts)], trueOpts)
#     }
#   )
# })

# Create a fake simulation (just an empty directory)
dir.create(file.path(studyPath, "output/30000101-0000fake"))

test_that("Select simulation with path", {
  f <- list.files(file.path(studyPath, "output"), full.names = TRUE)
  opts <- setSimulationPath(f[1])
  expect_equal(opts[names(trueOpts)], trueOpts)
})

test_that("Select simulation by name", {
  opts <- setSimulationPath(studyPath, "eco-test")
  expect_equal(opts[names(trueOpts)], trueOpts)
})

test_that("Select simulation by index", {
  opts <- setSimulationPath(studyPath, 1)
  expect_equal(opts[names(trueOpts)], trueOpts)
})

test_that("select simulation with negative index", {
  opts <- setSimulationPath(studyPath, -2)
  expect_equal(opts[names(trueOpts)], trueOpts)
})
# 
# test_that("select simulation interactively (number)", {
#   with_mock(
#     `base::scan` = function(...) {"1"},
#     {
#       expect_output(opts <- setSimulationPath(studyPath), "choose a simulation")
#       expect_equal(opts[names(trueOpts)], trueOpts)
#     }
#   )
# })
# 
# test_that("select simulation interactively (name)", {
#   with_mock(
#     scan = function(...) {"eco-test"},
#     {
#       expect_output(opts <- setSimulationPath(studyPath), "choose a simulation")
#       expect_equal(opts[names(trueOpts)], trueOpts)
#     }
#   )
# })

# Remove fake study
unlink(file.path(studyPath, "output/30000101-0000fake"), TRUE, TRUE)


# Study with no simulation #####################################################

# We rename the folder "output" to simulate a study without any simulation
# results
file.rename(file.path(studyPath, "output"), file.path(studyPath, "outputBack"))

describe("No simulation", {
  it("Error if the user tries to read simulation results", {
    expect_error(setSimulationPath(studyPath, 1))
  })
  
  it("User can read input data", {
    expect_silent(opts <- setSimulationPath(studyPath, 0))
    expect_equal(opts$mode, "Input")
  })
  
  it("Read input data by default", {
    expect_silent(opts <- setSimulationPath(studyPath))
    expect_equal(opts$mode, "Input")
  })
})

file.rename(file.path(studyPath, "outputBack"), file.path(studyPath, "output"))

# Antares v6 ###################################################################

test_that("Folder 'maps' is not interpreted as a study (#49)", {
  expect_silent(opts <- setSimulationPath(studyPath, -1))
})

}
})
