% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ramps.R
\name{netLoadRamp}
\alias{netLoadRamp}
\title{Ramp of an area}
\usage{
netLoadRamp(x, timeStep = "hourly", synthesis = FALSE,
  ignoreMustRun = FALSE)
}
\arguments{
\item{x}{Object of class \code{antaresData} containing data for areas and/or
districts. It must contain the column \code{BALANCE}  and either the column
"netLoad" or the columns needed to compute the net load.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{ignoreMustRun}{Should the must run production be ignored in the computation of the net
load?}
}
\value{
\code{netLoadRamp} returns a data.table or a list of data.tables with the
following columns:
\item{netLoadRamp}{
  Ramp of the net load of an area. If \code{timeStep} is not hourly, then these
  columns contain the average value for the given time step.
  Formula = netLoad - shift(netLoad, fill = 0)
}
\item{balanceRamp}{
  Ramp of the balance of an area. If \code{timeStep} is not hourly, then
  these columns contain the average value for the given time step.

  formula = BALANCE - shift(BALANCE, fill = 0)
}
\item{areaRamp}{
  Sum of the two previous columns. If \code{timeStep} is not hourly, then
  these columns contain the average value for the given time step.

  formula = netLoadRamp + balanceRamp
}
\item{minNetLoadRamp}{Minimum ramp of the net load of an area.}
\item{minBalanceRamp}{Minimum ramp of the balance of an area.}
\item{minAreaRamp}{Minimum ramp sum of the sum of balance and net load.}
\item{maxNetLoadRamp}{Maximum ramp of the net load of an area.}
\item{maxBalanceRamp}{Maximum ramp of the balance of an area.}
\item{maxAreaRamp}{Maximum ramp of the sum of balance and net load.}

For convenience the function invisibly returns the modified input.
}
\description{
This function computes the ramp of the consumption and the balance of areas
and/or districts.
}
\examples{
\dontrun{
# data required by the function
showAliases("netLoadRamp")

mydata <- readAntares(select="netLoadRamp")
addRamps(mydata, timeStep = "annual")
}

}
