% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createBindingConstraint.R
\name{create-binding-constraint}
\alias{create-binding-constraint}
\alias{createBindingConstraint}
\alias{createBindingConstraintBulk}
\title{Create a binding constraint}
\usage{
createBindingConstraint(
  name,
  id = tolower(name),
  values = NULL,
  enabled = TRUE,
  timeStep = c("hourly", "daily", "weekly"),
  operator = c("both", "equal", "greater", "less"),
  filter_year_by_year = "hourly, daily, weekly, monthly, annual",
  filter_synthesis = "hourly, daily, weekly, monthly, annual",
  coefficients = NULL,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)

createBindingConstraintBulk(constraints, opts = antaresRead::simOptions())
}
\arguments{
\item{name}{The name for the binding constraint.}

\item{id}{An id, default is to use the name.}

\item{values}{Values used by the constraint.
It contains one line per time step and three columns "less", "greater" and "equal".}

\item{enabled}{Logical, is the constraint enabled ?}

\item{timeStep}{Time step the constraint applies to : \code{hourly}, \code{daily} or \code{weekly}.}

\item{operator}{Type of constraint: equality, inequality on one side or both sides.}

\item{filter_year_by_year}{Marginal price granularity for year by year}

\item{filter_synthesis}{Marginal price granularity for synthesis}

\item{coefficients}{A named vector containing the coefficients used by the constraint, the coefficients have to be alphabetically ordered.}

\item{overwrite}{If the constraint already exist, overwrite the previous value.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}

\item{constraints}{A \code{list} of several named \code{list} containing data to create binding constraints.
\strong{Warning} all arguments for creating a binding constraints must be provided, see examples.}
}
\value{
An updated list containing various information about the simulation.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Create a new binding constraint in an Antares study.
\code{createBindingConstraintBulk()} allow to create multiple constraints at once.
}
\examples{
\dontrun{
createBindingConstraint(
  name = "myconstraint", 
  values = matrix(data = rep(0, 8760 * 3), ncol = 3), 
  enabled = FALSE, 
  timeStep = "hourly",
  operator = "both",
  coefficients = c("fr\%myarea" = 1)
)

# Create multiple constraints

# Prepare data for constraints 
bindings_constraints <- lapply(
  X = seq_len(100),
  FUN = function(i) {
    # use arguments of createBindingConstraint()
    # all arguments must be provided !
    list(
      name = paste0("constraints", i), 
      id = paste0("constraints", i), 
      values = matrix(data = rep(0, 8760 * 3), ncol = 3), 
      enabled = FALSE, 
      timeStep = "hourly",
      operator = "both",
      coefficients = c("area1\%area2" = 1),
      overwrite = TRUE
    )
  }
)
# create all constraints
createBindingConstraintBulk(bindings_constraints)
}
}
\seealso{
\code{\link[=editBindingConstraint]{editBindingConstraint()}} to edit existing binding constraints, \code{\link[=removeBindingConstraint]{removeBindingConstraint()}} to remove binding constraints.
}
