% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralClustering.R
\name{spectralClustering}
\alias{spectralClustering}
\title{Spectral clustering}
\usage{
spectralClustering(W, k)
}
\arguments{
\item{W}{NxN similarity matrix}

\item{k}{Number of clusters}
}
\value{
Cluster labels
}
\description{
Unnormalized spectral clustering function. Uses Partitioning Around Medoids clustering instead of K-means.
}
\examples{
#install igraph if necessary
#install.packages('igraph')
#install.packages('cluster')

library(igraph)
library(cluster)
library(anocva)

set.seed(2000)

#Create a tree graph
treeGraph = make_tree(80, children = 4, mode = "undirected")

#Visualize the tree graph
plot(treeGraph, vertex.size=10, vertex.label=NA)

#Get the adjacency matrix of the tree graph
adj = as.matrix(get.adjacency(treeGraph))

#Cluster the tree graph in to four clusters
cluster = spectralClustering(adj, 4)

#See the result clustering
plot(treeGraph, vertex.size=10, vertex.color = cluster, vertex.label=NA)

}

