% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestGuess.R
\name{bestGuess}
\alias{bestGuess}
\title{Select Best Classification From Multiple Frames}
\usage{
bestGuess(
  manifest,
  sort = "count",
  count = FALSE,
  shrink = FALSE,
  outfile = NULL,
  prompt = TRUE,
  parallel = FALSE,
  workers = 1
)
}
\arguments{
\item{manifest}{dataframe of all frames including species classification}

\item{sort}{method for selecting best prediction, defaults to most frequent}

\item{count}{if true, return column with number of MD crops for that animal (does not work for images)}

\item{shrink}{if true, return a reduced dataframe with one row per image}

\item{outfile}{file path to which the data frame should be saved}

\item{prompt}{if true, prompts the user to confirm overwrite}

\item{parallel}{Toggle for parallel processing, defaults to FALSE}

\item{workers}{number of processors to use if parallel, defaults to 1}
}
\value{
dataframe with new prediction in "Species" column
}
\description{
Select Best Classification From Multiple Frames
}
\examples{
\dontrun{
mdmanifest <- bestGuess(manifest, sort = "conf")
}
}
