% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deftype.R
\name{deftype}
\alias{deftype}
\title{deftype}
\usage{
deftype(index = NULL, FUN = NULL, xlim = c(-pi, pi))
}
\arguments{
\item{index}{index/name of the function}

\item{FUN}{function of the form \code{function(n, t) {...}}}

\item{xlim}{default range for displaying curves (default: \code{c(-pi,pi)})}
}
\value{
either a list of all functions or a single function
}
\description{
Defines a function which can be used as basis for Andrews curves \eqn{f_t(t) = \sum_{j=1}^p x_{ij} f_i(t)}.
}
\examples{
# define a new andrews curve, just with sine curves
deftype("sine", function(n, t) {
          n <- as.integer(if (n<1) 1 else n)
          m <- matrix(NA, nrow=length(t), ncol=n)
          for (i in 1:n) m[,i] <- sin(i*t)
          m
         })
andrews(iris, "sine")
# query
deftype()
deftype("sine")
}
