% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPosterior.R
\docType{methods}
\name{calcPosterior}
\alias{calcPosterior}
\alias{calcPosterior,MADproject-method}
\title{Calculate the posterior for a \code{MADproject} object.}
\usage{
calcPosterior(proj)

\S4method{calcPosterior}{MADproject}(proj)
}
\arguments{
\item{proj}{The \code{MADproject} object with the \code{likelihood}
slot filled.}
}
\value{
proj An updated \code{MADproject} object with the
\code{posterior} slot filled.
}
\description{
\code{calcPosterior} returns a MADproject object with the posterior values for each sample
}
\section{Methods (by class)}{
\itemize{
\item \code{MADproject}: Calculate the posterior value for each sample
}}

\examples{
data(pumping)
pumping.100 <- calcLikelihood(pumping, 100)
pumping.100 <- calcPosterior(pumping.100)

}
